<?php
/**
 * Background Mask Style - Arch.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Mask_Arch
 *
 * @since 4.15.0
 */
class ET_Builder_Mask_Arch extends ET_Builder_Background_Mask_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Arch', 'et-builder' ),
			'svgContent' => array(
				'default'          => array(
					'landscape' => '<path d="M1175.84,0H0V1440H1176.38c-110.64-207.53-174.88-454.91-174.88-720.5C1001.5,454.33,1065.54,207.33,1175.84,0Z"/>',
					'portrait'  => '<path d="M1175.43,0H0V2560H1176.38c-196.68-368.95-310.9-808.72-310.9-1280.89C865.48,807.7,979.33,368.58,1175.43,0Z"/>',
					'square'    => '<path d="M1175.66,0H0V1920H1176.38c-147.51-276.71-233.17-606.54-233.17-960.67C943.21,605.78,1028.59,276.44,1175.66,0Z"/>',
				),
				'default-inverted' => array(
					'landscape' => '<path d="M1920,0H1175.84c-110.3,207.33-174.34,454.33-174.34,719.5,0,265.59,64.24,513,174.88,720.5H1920Z"/>',
					'portrait'  => '<path d="M1175.43,0H1920V2560H1176.38c-196.68-368.95-310.9-808.72-310.9-1280.89C865.48,807.7,979.33,368.58,1175.43,0Z"/>',
					'square'    => '<path d="M1175.66,0H1920V1920H1176.38c-147.51-276.71-233.17-606.54-233.17-960.67C943.21,605.78,1028.59,276.44,1175.66,0Z"/>',
				),
				'rotated'          => array(
					'landscape' => '<path d="M0,545.16V1440H1920V544.62C1643.29,655.26,1313.46,719.5,959.33,719.5,605.78,719.5,276.44,655.46,0,545.16Z"/>',
					'portrait'  => '<path d="M0,1048.43V2560H1920V1047.72c-276.71,147.51-606.54,233.17-960.67,233.17C605.78,1280.89,276.44,1195.51,0,1048.43Z"/>',
					'square'    => '<path d="M0,728.34V1920H1920V727.62c-276.71,147.51-606.54,233.17-960.67,233.17C605.78,960.79,276.44,875.41,0,728.34Z"/>',
				),
				'rotated-inverted' => array(
					'landscape' => '<path d="M0,545.16V0H1920V544.62C1643.29,655.26,1313.46,719.5,959.33,719.5,605.78,719.5,276.44,655.46,0,545.16Z"/>',
					'portrait'  => '<path d="M0,1048.43V0H1920V1047.72c-276.71,147.51-606.54,233.17-960.67,233.17C605.78,1280.89,276.44,1195.51,0,1048.43Z"/>',
					'square'    => '<path d="M0,728.34V0H1920V727.62c-276.71,147.51-606.54,233.17-960.67,233.17C605.78,960.79,276.44,875.41,0,728.34Z"/>',
				),
			),
		);
	}
}

return new ET_Builder_Mask_Arch();
